
proc import datafile='...working folder\dat_anlz.txt'
            out=prune2
            dbms=dlm
            replace;
			getnames=yes;
            delimiter='09'x;
run;

data prune2;
  set prune2;

  length PS_GG $8; 
  PS_GG="PT2/3+4";
  if Path_Stage eq 'pT2' and Gleason_Grade eq '4+3' then PS_GG="PT2/4+3";
  if Path_Stage eq 'pT3a' and Gleason_Grade eq '3+4' then PS_GG="PT3a/3+4";
  if Path_Stage eq 'pT3a' and Gleason_Grade eq '4+3' then PS_GG="PT3a/4+3";

  treatment='RP'; *as Marc email in July, those 3 RP XRT should not be changed to RP;

  label YearsDiff='Years';
run;

* COX model with gene expression;
proc phreg data=prune2 plots=none;
   model yearsdiff*status(0)=PR;
   hazardratio PR;
   ods output HazardRatios=hr_pr ParameterEstimates=est_pr;
run;

proc phreg data=prune2 plots=none;
   model yearsdiff*status(0)=PC;
   hazardratio PC;
   ods output HazardRatios=hr_pc ParameterEstimates=est_pc;
run;

proc phreg data=prune2 plots=none;
   model yearsdiff*status(0)=Ratio;
   hazardratio Ratio;
   ods output HazardRatios=hr_ratio ParameterEstimates=est_ratio;
run;


* Model comparison;
* Model 1;
title 'Model 1';
proc phreg data=prune2;
  class PS_GG;
  model yearsdiff*status(0) = PS_GG;
run; *AIC: 157.202, SBC: 160.035;

proc phreg data=prune2 plots(overlay)=surv;
   class PS_GG (ref='PT2/3+4');
   model yearsdiff*status(0)=PS_GG;
   hazardratio PS_GG/diff=ref;
   *ods output HazardRatios=hr_pr ParameterEstimates=est_pr;
   baseline covariates=prune2 /diradj group=PS_GG;
run;

* Model 2;
title 'Model 2';
proc phreg data=prune2;
  class RACE PS_GG;
  model yearsdiff*status(0) = PR Age Race PS_GG PS_GG*PR;
run; *AIC: 162.9, SBC: 174;

proc phreg data=prune2;
  class RACE (ref='W') PS_GG (ref='PT2/3+4')/param=ref;
  model yearsdiff*status(0) = PR Age Race PS_GG PS_GG*PR/RL;
  hazardratio PS_GG/diff=ref;
  hazardratio RACE/diff=ref;
run; *AIC: 162.9, SBC: 174;

* Model 3;
title 'Model 3';
proc phreg data=prune2;
  class RACE PS_GG;
  model yearsdiff*status(0) = PC Age Race PS_GG PS_GG*PC;
run; *AIC: 166, SBC: 177;

proc phreg data=prune2;
  class RACE (ref='W') PS_GG (ref='PT2/3+4')/param=ref;
  model yearsdiff*status(0) = PC Age Race PS_GG PS_GG*PC/RL;
  hazardratio PS_GG/diff=ref;
  hazardratio RACE/diff=ref;
run; *AIC: 166, SBC: 177;

* Model 4;
title 'Model 4';
proc phreg data=prune2;
  class RACE PS_GG;
  model yearsdiff*status(0) = Ratio Age Race PS_GG PS_GG*Ratio;
run; *AIC: 162.17, SBC: 173;

proc phreg data=prune2;
  class RACE (ref='W') PS_GG (ref='PT2/3+4')/param=ref;
  model yearsdiff*status(0) = Ratio Age Race PS_GG PS_GG*Ratio/RL;
  hazardratio PS_GG/diff=ref;
  hazardratio RACE/diff=ref;
run; *AIC: 162.17, SBC: 173;

* Model with Stepwise selcetion;
title 'Model with Stepwise selection';
proc phreg data=prune2;
  class RACE PS_GG;
  model yearsdiff*status(0) = PR PC Age Race PS_GG PS_GG*PR PS_GG*PC
                              /selection=stepwise slentry=0.25 details; *slentry: sig. level for entering an var; *slstay: sig. level for removing an var;
run;
